/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.trial;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.screens.trial.AbstractTrial;
import com.megacrit.cardcrawl.screens.trial.TestTrial;
import com.megacrit.cardcrawl.ui.buttons.CancelButton;
import java.util.ArrayList;
import java.util.Random;

public class TrialScreen {
    private Color screenColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private float alphaTarget = 0.0f;
    public boolean screenUp = false;
    private CancelButton button = new CancelButton();
    private float screenX = -800.0f * Settings.scale;
    private float targetX = -800.0f * Settings.scale;
    private ArrayList<AbstractTrial> trials = new ArrayList();

    public TrialScreen() {
        this.trials.add(new TestTrial());
    }

    public void update() {
        this.button.update();
        this.screenColor.a = MathHelper.popLerpSnap(this.screenColor.a, this.alphaTarget);
        this.screenX = MathHelper.uiLerpSnap(this.screenX, this.targetX);
        float y = 750.0f * Settings.scale;
        for (AbstractTrial t : this.trials) {
            t.update(this.screenX + 100.0f * Settings.scale, y);
            y -= 100.0f * Settings.scale;
        }
    }

    public void show() {
        if (!this.screenUp) {
            this.screenUp = true;
            this.alphaTarget = 0.8f;
            this.button.show("Return");
            this.targetX = 100.0f * Settings.scale;
        }
    }

    public void hide() {
        if (this.screenUp) {
            this.screenUp = false;
            this.alphaTarget = 0.0f;
            this.button.hide();
            this.targetX = -800.0f * Settings.scale;
        }
    }

    public void render(SpriteBatch sb) {
        sb.setColor(this.screenColor);
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
        this.button.render(sb);
        FontHelper.renderSmartText(sb, FontHelper.charTitleFont, "The Trials", this.screenX + 50.0f * Settings.scale, 850.0f * Settings.scale, 9999.0f, 32.0f * Settings.scale, Settings.CREAM_COLOR);
        for (AbstractTrial t : this.trials) {
            t.render(sb);
        }
    }

    public void startTrial(AbstractTrial trial) {
        CardCrawlGame.trial = trial;
        CardCrawlGame.mainMenuScreen.isFadingOut = true;
        this.hide();
        Settings.seed = new Random().nextLong();
        Settings.isTrial = true;
        AbstractDungeon.generateSeeds();
        CardCrawlGame.mainMenuScreen.fadeOutMusic();
    }
}

